<?php
/*======================================================================*\
|| #################################################################### ||
|| # v3 Arcade for vBulletin                                          # ||
|| # Support: http://www.v3arcade.com                                 # ||
|| # Copyright: http://www.cinvin.com                                 # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);
@set_time_limit(0);

// #################### PRE-CACHE TEMPLATES AND DATA ######################
$phrasegroups = array(
	'cpuser',
	'v3arcade',
	'v3arcade_admin',
	'user'
);

if ($_REQUEST['do'] == 'settings')
{
	$phrasegroups[] = 'cpoption';
}

$specialtemplates = array(
	'arcade_bitdef',
	'v3a_mochitemp'
);

// ############################################################################
// ##### Game Install From Mochiads.com
// ############################################################################
if ($_REQUEST['do'] == 'mochilive')
{
	define('VB_AREA', 'forum');
	chdir('../');
	require_once('./includes/init.php');
	require_once(DIR . '/includes/v3arcade_functions_admin.php');

	$vbulletin->input->clean_gpc('p', 'game_tag', TYPE_NOHTML);

	if (!$vbulletin->GPC['game_tag'])
	{
		exit;
	}

	if (!is_array($vbulletin->v3a_mochitemp))
	{
		$vbulletin->v3a_mochitemp = array();
	}

	$gamecache = cache_games();
	$shortname = substr(strrchr($mochi['link']['0']['href'], '/'), 1);

	if ($gamecache[$shortname])
	{
		exit;
	}

	// make sure the game sent actually exists just to be safe
	require_once(DIR . '/includes/class_xml.php');
	if (!$xml = new XMLparser(false, 'http://www.mochimedia.com/feeds/games/' . $vbulletin->options['arcademochi'] . '/' . $vbulletin->GPC['game_tag']))
	{
		exit;
	}

	// Remove all from current page to allow for un-checking games after re-visting a page
	if (!in_array($vbulletin->GPC['game_tag'], $vbulletin->v3a_mochitemp))
	{
		$vbulletin->v3a_mochitemp[] = $vbulletin->GPC['game_tag'];
	  build_datastore('v3a_mochitemp', serialize($vbulletin->v3a_mochitemp), 1);
	}

	exit;
}

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');
require_once(DIR . '/includes/v3arcade_functions.php');
require_once(DIR . '/includes/v3arcade_functions_admin.php');

// Check Admin Permissions
if (!can_administer('canadminforums'))
{
	print_cp_no_permission();
}

if (!is_array($vbulletin->v3a_mochitemp))
{
	$vbulletin->v3a_mochitemp = array();
}

// ####################### v3arcade_admin.php FUNCTIONS ######################
// ############################################################################
// v3 ARCADE LIVE LINK - Download new content from the v3 Arcade site.
// ############################################################################
if ($_REQUEST['do'] == 'liveinstall')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'licenseid' => TYPE_NOHTML
	));

	exec_header_redirect('index.php?' . $vbulletin->session->vars['sessionurl_js'] . 'loc=' . urlencode('v3arcade_admin.php?' . $vbulletin->session->vars['sessionurl_js'] . 'do=checkgames&licenseid=' . $vbulletin->GPC['licenseid']));
}

if ($_REQUEST['do'] == 'checkgames')
{
	print_cp_header($vbphrase['v3_live_link']);

	$vbulletin->input->clean_array_gpc('r', array(
		'licenseid' => TYPE_NOHTML
	));

	require_once(DIR . '/includes/class_xml.php');
	$xmlobj = new XMLparser(false, 'http://www.v3arcade.com/link/init.php?do=checkgames&licenseid=' . $vbulletin->GPC['licenseid']);

	if (!$link = $xmlobj->parse())
	{
		print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
	}

	print_form_header('v3arcade_admin', 'installgames');

	if ($link['status']['active'] == 1)
	{
		print_table_header($vbphrase['content_server_status']);
		print_cells_row(array($link['status']['message']));
		print_table_break();
	}
	else
	{
		print_cp_message($link['status']['message']);
	}

	// Installed game cache.
	$gamecache = cache_games();

	print_table_header($vbphrase['installation_list']);

	// If no games have been chosen.
	if (!$link['game'])
	{
		print_cells_row(array($vbphrase['no_games_chosen']));
		print_table_footer();
	}
	else
	{
		print_cells_row(array($vbphrase['game'], $vbphrase['status']), true);
		// There's more than one game.
		if ($link['game'][1])
		{
			foreach ($link['game'] as $key => $val)
			{
				print_cells_row(array("$val[title]<br /><dfn>$val[description]</dfn>", iif(in_array($val['shortname'], $gamecache), $vbphrase['installed'], $vbphrase['not_installed'])));
			}
		}
		else
		{
			// There's only one game.
			print_cells_row(array($link['game']['title'] . '<br /><dfn>' . $link['game']['description'] . '</dfn>', iif(in_array($link['game']['shortname'], $gamecache), $vbphrase['installed'], $vbphrase['not_installed'])));
		}
		construct_hidden_code('licenseid', $vbulletin->GPC['licenseid']);
		print_submit_row($vbphrase['proceed_with_installation'], '');
	}
}

// ############################################################################
// v3 ARCADE LIVE LINK - Install from v3arcade website
// ############################################################################
if ($_REQUEST['do'] == 'installgames')
{
	print_cp_header($vbphrase['v3_live_link']);
	print_dots_start_arcade($vbphrase['checking_installation_queue'], '|', 'gp1');

	$vbulletin->input->clean_array_gpc('r', array(
		'licenseid' => TYPE_NOHTML
	));

	require_once(DIR . '/includes/class_xml.php');
	$xmlobj = new XMLparser(false, 'http://www.v3arcade.com/link/init.php?do=install&licenseid=' . $vbulletin->GPC['licenseid']);

	if (!$link = $xmlobj->parse())
	{
		print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
	}
	vbflush();
	sleep(1);

	print_dots_stop_arcade('gp1');

	if (!is_array($link['game']))
	{
		$gotopage = 'http://www.v3arcade.com/forums/games.php?do=finish';
		// print_cp_redirect($gotopage);
		echo '<p align="center" class="smallfont"><a href="' . $gotopage . '">' . $vbphrase['processing_complete_proceed'] . '</a></p>';
		echo "\n<script type=\"text/javascript\">\n";
		echo "top.location=\"$gotopage\";";
		echo "\n</script>\n";
	}
	else
	{
		$thisgame =& $link['game'];
		// Install the current game.

		print_dots_start_arcade(construct_phrase($vbphrase['checking_x_status'], $thisgame[title]), "|", 'gp2');

		if ($db->query_first("SELECT gameid, shortname FROM " . TABLE_PREFIX . "v3arcade_games WHERE shortname = '" . $db->escape_string($thisgame['shortname']) . "'"))
		{
			$thisgame['doinstall'] = false;

			// Call home to remove this license.
			$xmlobj = new XMLparser(false, 'http://www.v3arcade.com/link/init.php?do=invalidate&licenseid=' . $vbulletin->GPC['licenseid'] . '&gameid=' . $thisgame['gameid']);

			if (!$invcheck = $xmlobj->parse())
			{
				print_stop_message('xml_error_x_at_line_y', $xmlobj->error_string(), $xmlobj->error_line());
			}

			vbflush();
			sleep(1);
			print_dots_stop_arcade('gp2');

			// The user already has this game installed.
			print_cp_message(construct_phrase($vbphrase['x_already_installed'], $thisgame['title']), 'v3arcade_admin.php?do=installgames&licenseid=' . $vbulletin->GPC['licenseid'], 1);
		}
		else
		{
			$thisgame['doinstall'] = true;

			vbflush();
			sleep(1);
			print_dots_stop_arcade('gp2');
		}

		if ($thisgame['doinstall'])
		{
			print_dots_start_arcade($vbphrase['downloading_game_data'], '|', 'gp3');

			$real_path = realpath('./');

			// Get the next queued game.
			$contents = file_get_contents('http://www.v3arcade.com/link/init.php?do=download&licenseid=' . $vbulletin->GPC['licenseid']);

			// Get the class we're going to use to untar files.
			require_once(DIR . '/includes/v3arcade_class_tar.php');

			$gametar = new tar;
			if ($gametar->openTAR($contents, 1))
			{
				foreach ($gametar->files as $key => $val)
				{
					if (!strpos($val['name'], '/'))
					{
						// Figure out where this file is going.
						switch (substr($val['name'], strlen($val['name']) - 4, 4))
						{
							case '.gif':
								$newfile = $real_path . '/' . $vbulletin->options['arcadeimages'] . '/' . $val['name'];
							break;
							case '.swf':
								$newfile = $real_path . '/' . $vbulletin->options['gamedir'] . '/' . $val['name'];
							break;
						}

						if ($newfile AND $handle = fopen($newfile, 'wb') )
						{
							fputs($handle, $val['file'], strlen($val['file']));
							fclose($handle);
						}
					}
				}
			}

			print_dots_stop_arcade('gp3');

			print_dots_start_arcade(construct_phrase($vbphrase['installing_x'], $thisgame['title']), '|', 'gp4');

			// Insert the game
			insert_v3a_game(array(
				'shortname' => $thisgame['shortname'],
				'title' => $thisgame['title'],
				'description' => $thisgame['description'],
				'file' => $thisgame['file'],
				'width' => $thisgame['width'],
				'height' => $thisgame['height'],
				'stdimage' => $thisgame['stdimage'],
				'miniimage' => $thisgame['miniimage'],
				'dateadded' => TIMENOW
			));

			print_dots_stop_arcade('gp4');

			print_cp_redirect('v3arcade_admin.php?do=installgames&licenseid=' . $vbulletin->GPC['licenseid'], 2);
		}
	}
}

// ############################################################################
// SETTINGS - Print a select field of all v3A setting groups
// ############################################################################
if ($_REQUEST['do'] == 'settings')
{
	print_cp_header($vbphrase['settings']);

	$getphrases = $db->query_read("
		SELECT varname, text
		FROM " . TABLE_PREFIX . "phrase
		WHERE fieldname = 'vbsettings'
			AND product = 'v3arcade'
		ORDER BY languageid ASC
	");
	while($phrase = $db->fetch_array($getphrases))
	{
		$vbphrase[$phrase['varname']] = $phrase['text'];
	}

	/*
	Prefix other products with "v3arcade" to have their setting groups show up here
	*/
	$sgroupcache = array();
	$getgroups = $db->query_read("
		SELECT grouptitle
		FROM " . TABLE_PREFIX . "settinggroup
		WHERE product LIKE 'v3arcade%'
		ORDER BY displayorder
	");
	while ($groups = $db->fetch_array($getgroups))
	{
		$sgroupcache[$groups['grouptitle']] = $vbphrase['settinggroup_' . $groups['grouptitle']];
	}

	print_form_header('options', 'options', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header($vbphrase['v3arcade_settings']);

	print_select_row(
		$vbphrase['settings_to_edit'],
		'dogroup',
		$sgroupcache,
		key($sgroupcache),
		false,
		(sizeof($sgroupcache) > 10 ? 10 : sizeof($sgroupcache)) . '" ondblclick="this.form.submit();',
		true
	);
	
	print_submit_row($vbphrase['edit_settings'], false);

}

// ############################################################################
// GAMES - Find games and edit their permissions.
// ############################################################################
if ($_REQUEST['do'] == 'games')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_UINT,
		'lastsearch' => TYPE_NOHTML,
		'orderby' => TYPE_NOHTML,
		'orderdir' => TYPE_NOHTML,
		'pagenumber' => TYPE_UINT,
		'perpage' => TYPE_UINT,
		'title' => TYPE_NOHTML
	));

	$showprev = false;
	$shownext = false;
	$sorturl = '';
	$orderby =& $vbulletin->GPC['orderby'];
	$orderdir =& $vbulletin->GPC['orderdir'];

	// search by title
	if ($vbulletin->GPC['title'])
	{
		$wherequery = "WHERE games.title LIKE '%" . $db->escape_string($vbulletin->GPC['title']) . "%'";
		$sorturl .= '&amp;title=' . $vbulletin->GPC['title'];
	}

	// limit by category
	if ($vbulletin->GPC['catid'])
	{
		$wherequery = 'WHERE games.categoryid = ' . $vbulletin->GPC['catid'];
		$sorturl .= '&amp;catid=' . $vbulletin->GPC['catid'];
	}

	$gamecount = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "v3arcade_games AS games
		$wherequery
	");

	if (($vbulletin->GPC['pagenumber'] < 1) OR ($vbulletin->GPC['lastsearch'] != $vbulletin->GPC['title']))
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	
	if (!$vbulletin->GPC['perpage'])
	{
		$vbulletin->GPC['perpage'] = $vbulletin->options['gamesperpage'];
	}
	
	$sorturl .= '&amp;perpage=' . $vbulletin->GPC['perpage'];

	$totalpages = ceil($gamecount['total'] / $vbulletin->GPC['perpage']);
	if ($totalpages < 1)
	{
		$totalpages = 1;
	}

	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage'];

	if (!$orderby)
	{
		$orderby = 'title';
	}

	if ($orderdir != 'DESC')
	{
		$orderdir = 'ASC';
	}

	$sortarrow[$orderby] = ' <a href="v3arcade_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=games&amp;orderby=' . $orderby . '&amp;orderdir=' . ($orderdir == 'DESC' ? 'ASC' : 'DESC') . $sorturl . '"><img src="../cpstyles/' . $vbulletin->options['cpstylefolder'] . '/move_' . ($orderdir == 'ASC' ? 'up' : 'down') . '.gif" alt="" border="0" /></a>';

	$showprev = ($vbulletin->GPC['pagenumber'] > 1);
	$shownext = ($vbulletin->GPC['pagenumber'] < $totalpages);

	$pageoptions = array();
	for ($i = 1; $i <= $totalpages; $i++)
	{
		$pageoptions[$i] = "$vbphrase[page] $i / $totalpages";
	}

	$gameoptions = array(
		'edit' => $vbphrase['edit'],
		'delete' => $vbphrase['delete']
	);

	$pagenavigation = '
		<input type="button"' . iif(!$showprev, ' disabled="disabled"') . ' class="button" value="&laquo; ' . $vbphrase['prev'] . '" tabindex="1" onclick="document.cpform.page.selectedIndex -= 1; document.cpform.submit()" />
		<select name="page" tabindex="1" onchange="document.cpform.submit()" class="bginput">' . construct_select_options($pageoptions, $vbulletin->GPC['pagenumber']) . '</select>
		<input type="button"' . iif(!$shownext, ' disabled="disabled"') . ' class="button" value="' . $vbphrase['next'] . ' &raquo;" tabindex="1" onclick="document.cpform.page.selectedIndex += 1; document.cpform.submit()" />
	';

	print_cp_header($vbphrase['arcade_games']);

	?>
<script type="text/javascript">
<!--
function js_game_jump(gameid)
{
	action = eval("document.cpform.g" + gameid + ".options[document.cpform.g" + gameid + ".selectedIndex].value");

	switch (action)
	{
		case 'edit':
			page = "editgame";
		break;

		case 'delete':
			page = "deletegame";
			confirmdelete = confirm('<?php echo $vbphrase['are_you_sure_delete_game']; ?>');

			if (confirmdelete != true)
			{
				return;
			}
		break;
	}

	document.cpform.reset();
	jumptopage = "v3arcade_admin.php?do=" + page + "&gameid=" + gameid + "&s=<?php echo $vbulletin->session->vars['sessionhash']; ?>";

	window.location = jumptopage;
}
-->
</script>

	<?php

	// Game search / Pagenav / Games per page
	print_form_header('v3arcade_admin', 'games', false, true, 'cpform', '90%', '', true, 'get');
	construct_hidden_code('lastsearch', $vbulletin->GPC['title']);
	construct_hidden_code('orderby', $orderby);
	construct_hidden_code('orderdir', $orderdir);
	
	echo '
	<colgroup span="5">
		<col style="white-space:nowrap"></col>
		<col></col>
		<col width="100%" align="center"></col>
		<col style="white-space:nowrap"></col>
		<col></col>
	</colgroup>
	<tr>
		<td class="thead" nowrap>' . $vbphrase['game_search'] . ':</td>
		<td class="thead"><input type="text" name="title" class="bginput" tabindex="1" value="' . $vbulletin->GPC['title'] . '" /></td>
		<td class="thead">
			' . $vbphrase['show_games_from'] . ' <select name="catid">' . construct_select_options(fetch_arcade_cats(array(0 => $vbphrase['all_categories'])), $vbulletin->GPC['catid']) . '</select>
		</td>
		<td class="thead" nowrap>' . $vbphrase['games_per_page'] . ':</td>
		<td class="thead"><input type="text" class="bginput" name="perpage" value="' . $vbulletin->GPC['perpage'] . '" tabindex="1" size="5" /></td>
		<td class="thead"><input type="submit" class="button" value=" ' . $vbphrase['go'] . ' " tabindex="1" accesskey="s" /></td>
	</tr>';

	print_table_footer(2, '', '', false);

	// Start the games table
	print_table_start();
	print_table_header('<span style="float: ' . $stylevar['right'] . '">' . $pagenavigation . '</span><div align="' . $stylevar['left'] . '">' . $vbphrase['arcade_games'] . '</div>', 6);

	echo '<tr valign="top" align="center">
	<td class="thead" align="left" width="1%">&nbsp;</td>
	<td class="thead" align="left"><a href="v3arcade_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=games&amp;orderby=title' . $sorturl . '">' . $vbphrase['title'] . '</a>' . $sortarrow['title'] . '</td>
	<td class="thead"><a href="v3arcade_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=games&amp;orderby=username' . $sorturl . '">' . $vbphrase['high_scorer'] . '</a>' . $sortarrow['username'] . '</td>
	<td class="thead"><a href="v3arcade_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=games&amp;orderby=highscore' . $sorturl . '">' . $vbphrase['high_score'] . '</a>' . $sortarrow['highscore'] . '</td>
	<td class="thead"><a href="v3arcade_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=games&amp;orderby=sessioncount' . $sorturl . '">' . $vbphrase['times_played'] . '</a>' . $sortarrow['sessioncount'] . '</td>
	<td class="thead">' . $vbphrase['options'] . '</td>
</tr>';

	$games = $db->query_read("
		SELECT games.*, cats.catname, user.username
		FROM " . TABLE_PREFIX . "v3arcade_games AS games
		LEFT JOIN " . TABLE_PREFIX . "v3arcade_categories AS cats ON (games.categoryid = cats.categoryid)
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.highscorerid = user.userid)
		$wherequery
		ORDER BY " . ($orderby == 'username' ? 'user' : 'games') . ".$orderby $orderdir
		LIMIT $startat, " . $vbulletin->GPC['perpage']
	);
	while ($game = $db->fetch_array($games))
	{
		$game['link'] = '<a ' . (($game['gamepermissions'] & $vbulletin->bf_misc_gamepermissions['isactive']) ? '' : 'style="text-decoration: line-through;" title="' . $vbphrase['inactive'] . '" ') . 'href="v3arcade_admin.php?' . $vbulletin->session->vars['sessionurl'] . 'do=editgame&amp;gameid=' . $game['gameid'] . '">' . $game['title'] . '</a>';

		print_cells_row(array(
			'<img src="../' . $vbulletin->options['arcadeimages'] . '/' . $game['miniimage'] . '" align="absmiddle" height="' . $vbulletin->options['arcadethumbsize'] . '" width="' . $vbulletin->options['arcadethumbsize'] . '" />',
			$game['link'] . '<div class="smallfont"><em>' . $game['catname'] . '</em></div>',
			($game['highscorerid'] ? 
				'<div class="smallfont"><a href="../member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $game['highscorerid'] . '" target="_blank">' . $game['username'] . '</a></div>' :
				''
			),
			vb_number_format($game['highscore']),
			vb_number_format($game['sessioncount']),
			"<select name=\"g$game[gameid]\" onchange=\"js_game_jump($game[gameid]);\" class=\"bginput\">\n" . construct_select_options($gameoptions) . "\t</select><input type=\"button\" class=\"button\" value=\"" . $vbphrase['go'] . "\" onclick=\"js_game_jump($game[gameid]);\" />"
		), false, false, -1);
	}

	print_table_footer();

	// Mass process game settings
	// name the form so it doesn't conflict with the above javascript
	print_form_header('v3arcade_admin', 'processgames', false, true, 'newgameform');
	print_table_header($vbphrase['mass_process_game_settings']);
	print_description_row($vbphrase['mass_process_game_settings_note']);
	print_select_row($vbphrase['show_games_from'], 'catid', fetch_arcade_cats(array(0 => $vbphrase['all_categories'])));
	print_input_row($vbphrase['games_per_page'] . $vbphrase['games_per_page_dfn'], 'perpage', $vbulletin->options['gamesperpage']);
	print_submit_row($vbphrase['start'], false);
}

// ############################################################################
// ADD/EDIT GAME
// ############################################################################
if ($_REQUEST['do'] == 'addgame' OR $_REQUEST['do'] == 'editgame')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'gameid' => TYPE_UINT
	));

	print_cp_header($vbphrase['arcade_games']);

	if ($_REQUEST['do'] == 'addgame')
	{
		$headerphrase = $vbphrase['add_new_game'];
		
		$game = array('categoryid' => 1);
		
		$game['permissions'] = array(
			'isactive' => 1,
			'showaward' => 1,
			'enablechallenges' => 1
		);
	}
	else
	{
		$game = $db->query_first("
			SELECT * FROM " . TABLE_PREFIX . "v3arcade_games
			WHERE gameid = " . $vbulletin->GPC['gameid']
		);
	
		if (!$game['gameid'])
		{
			print_stop_message(construct_phrase('invalid_x_specified'), $vbphrase['game']);
		}

		$game['permissions'] = convert_bits_to_array($game['gamepermissions'], $vbulletin->bf_misc_gamepermissions);
		
		$headerphrase = construct_phrase($vbphrase['editing_game_x'], $game['title']);
	}

	$catoptions = fetch_arcade_cats();

	print_form_header('v3arcade_admin', 'doeditgame');
	print_table_header($headerphrase);

	print_input_row($vbphrase['game_title'], 'game[title]', $game['title']);
	print_textarea_row($vbphrase['game_description'], 'game[description]', $game['description']);
	print_select_row($vbphrase['game_category'], 'game[categoryid]', $catoptions, $game['categoryid']);

	if ($_REQUEST['do'] == 'addgame')
	{
		print_input_row($vbphrase['game_shortname'], 'game[shortname]', $game['shortname']);
		print_select_row(
			$vbphrase['game_system'],
			'game[system]',
			array(
				0 => $vbphrase['v3arcade'],
				10 => $vbphrase['ibpro_arcade'],
				99 => $vbphrase['mochiads']
			),
			$game['system']);
	}

	print_textarea_row($vbphrase['game_instructions'], 'game[instructions]', $game['instructions']);
	print_input_row($vbphrase['game_keywords'], 'game[keywords]', $game['keywords']);
	print_input_row(construct_phrase($vbphrase['game_swf_file'], $vbulletin->options['gamedir']), 'game[file]', $game['file']);
	print_input_row($vbphrase['width'] . $vbphrase['width_dfn'], 'game[width]', $game['width']);
	print_input_row($vbphrase['height'] . $vbphrase['height_dfn'], 'game[height]', $game['height']);

	if ($_REQUEST['do'] == 'addgame')
	{
		print_input_row(construct_phrase($vbphrase['game_std_image'], $vbulletin->options['arcadeimages']), 'game[stdimage]', $game['stdimage']);
		print_input_row(construct_phrase($vbphrase['game_mini_image'], $vbulletin->options['arcadeimages']), 'game[miniimage]', $game['miniimage']);
	}
	else
	{
		print_label_row(
			$vbphrase['game_icons'],
			'<div align="left"><img src="../' . $vbulletin->options['arcadeimages'] . '/' . $game['stdimage'] . '" />' . ' <img src="../' . $vbulletin->options['arcadeimages'] . '/' . $game['miniimage'] . '" /></div>'
		);
	}

	print_yes_no_row($vbphrase['active'] . $vbphrase['is_active_dfn'], 'gamepermissions[isactive]', $game['permissions']['isactive']);
	print_yes_no_row($vbphrase['disable_high_scores'], 'gamepermissions[disablescoring]', $game['permissions']['disablescoring']);
	print_yes_no_row($vbphrase['show_award'], 'gamepermissions[showaward]', $game['permissions']['showaward']);
	print_yes_no_row($vbphrase['enable_challenges'], 'gamepermissions[enablechallenges]', $game['permissions']['enablechallenges']);
	print_yes_no_row($vbphrase['use_reverse'], 'game[isreverse]', $game['isreverse']);

	// vbBux Integration
	if ($vbulletin->options['vbbux_pointsfield'])
	{
		print_input_row($vbphrase['game_cost'], 'game[cost]', $game['cost']);
	}

	print_table_break();

	print_table_header($vbphrase['access_restrictions']);
	print_input_row($vbphrase['minpoststotal'], 'game[minpoststotal]', $game['minpoststotal']);
	print_input_row($vbphrase['minpostsperday'], 'game[minpostsperday]', $game['minpostsperday']);
	print_input_row($vbphrase['minpoststhisday'], 'game[minpoststhisday]', $game['minpoststhisday']);
	print_input_row($vbphrase['minreglength'], 'game[minreglength]', $game['minreglength']);
	print_input_row($vbphrase['minrep'], 'game[minrep]', $game['minrep']);

	// hook to allow new game fields to be editable
	($hook = vBulletinHook::fetch_hook('arcade_admin_edit_game')) ? eval($hook) : false;

	construct_hidden_code('gameid', $vbulletin->GPC['gameid']);
	print_submit_row($vbphrase['save'], '');
}

// ############################################################################
// DO EDIT GAME
// ############################################################################
if ($_REQUEST['do'] == 'doeditgame')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'gameid' => TYPE_UINT,
		'game' => TYPE_ARRAY,
		'gamepermissions' => TYPE_ARRAY_BOOL,
	));

	// Get that bitfield value calculated.
	require_once(DIR . '/includes/functions_misc.php');
	$vbulletin->GPC['game']['gamepermissions'] = convert_array_to_bits($vbulletin->GPC['gamepermissions'], $vbulletin->bf_misc_gamepermissions);

	$db->query_write(fetch_query_sql(
		$vbulletin->GPC['game'],
		'v3arcade_games',
		($vbulletin->GPC['gameid'] ? 'WHERE gameid = ' . $vbulletin->GPC['gameid'] : false)
	));

	print_cp_redirect('v3arcade_admin.php?do=games');
}

// ############################################################################
// DELETE GAME
// ############################################################################
if ($_REQUEST['do'] == 'deletegame')
{
	print_cp_header($vbphrase['arcade_games']);

	$vbulletin->input->clean_gpc('r', 'gameid', TYPE_UINT);

	if ($thisgame = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "v3arcade_games
		WHERE gameid = " . $vbulletin->GPC['gameid']
	))
	{
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "v3arcade_games WHERE gameid = " . $vbulletin->GPC['gameid']);
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "v3arcade_sessions WHERE gameid = " . $vbulletin->GPC['gameid']);
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "v3arcade_favorites WHERE gameid = " . $vbulletin->GPC['gameid']);
		$db->query_write("DELETE FROM " . TABLE_PREFIX . "v3arcade_ratings WHERE gameid = " . $vbulletin->GPC['gameid']);

		$image_path = realpath($vbulletin->options['arcadeimages']);
		$gamedata_path = realpath(DIR  . '/arcade/gamedata/' . $thisgame['shortname']);

		@unlink(realpath($vbulletin->options['gamedir']) . '/' . $thisgame['shortname'] . '.swf');
		@unlink($image_path . '/' . $thisgame['shortname'] . '1.gif');
		@unlink($image_path . '/' . $thisgame['shortname'] . '2.gif');

		// Check to see if a 'gamedata' folder exists for the game and
		// remove it if it does exist.  Needed to remove IBP v32+ games.
    if (is_dir($gamedata_path))
		{
			// Fix for UMASK problem (Ref: http://us3.php.net/manual/en/function.mkdir.php#33513)
			$old_umask = umask(0);

			delete_directory($gamedata_path);

			// Reset the UMASK settings
			umask($old_umask);
		}

		build_arcade_champ_cache();

		// hook to do any additional actions upon game deletion
		($hook = vBulletinHook::fetch_hook('arcade_admin_game_delete_process')) ? eval($hook) : false;
	}
	
	print_cp_redirect('v3arcade_admin.php?do=games');
}


// ############################################################################
// GAME TOOLS - Everything to do with adding games.
// ############################################################################
if ($_REQUEST['do'] == 'gametools')
{
	print_cp_header($vbphrase['arcade_games']);

	print_form_header('v3arcade_admin', 'mochi');
	print_table_header($vbphrase['browse_mochiads_games']);
	print_description_row($vbphrase['browse_mochiads_games_desc']);

	// Browse mochiads.com games
	if (!$vbulletin->options['arcademochi'] OR !$vbulletin->options['arcademochi_secret'])
	{
		print_description_row($vbphrase['browse_mochiads_games_desc_register']);
		print_table_footer();
	}
	else
	{
		print_description_row(
			$vbphrase['browse_mochiads_games_desc_start_browsing'] . 
			(!empty($vbulletin->v3a_mochitemp) ? '<br />' . construct_phrase($vbphrase['x_games_to_be_imported'], sizeof($vbulletin->v3a_mochitemp)) : '')
		);
		print_submit_row($vbphrase['browse_mochiads_games'], false);
	}

	// v3 Import
	print_form_header('v3arcade_admin', 'v3import');
	print_table_header($vbphrase['v3_import']);
	print_description_row($vbphrase['v3_importnote']);
	print_input_row($vbphrase['file_path'], 'filepath', 'admincp/games');
	print_input_row($vbphrase['games_per_page'] . $vbphrase['games_per_page_process_dfn'], 'gamesperpage', 10);
	print_submit_row($vbphrase['start'], false);

	// IB Pro Import
	print_form_header('v3arcade_admin', 'ibimport');
	print_table_header($vbphrase['ib_import']);
	print_description_row($vbphrase['ib_importnote']);
	print_input_row($vbphrase['file_path'], 'filepath', 'admincp/games');
	print_input_row($vbphrase['games_per_page'] . $vbphrase['games_per_page_process_dfn'], 'gamesperpage', 10);
	print_submit_row($vbphrase['start'], false);

	// Manually add game
	print_form_header('v3arcade_admin', 'addgame');
	print_table_header($vbphrase['manually_add_game']);
	print_description_row($vbphrase['manually_add_game_desc']);
	print_submit_row($vbphrase['manually_add_game'], false);

	// New game tool links
	($hook = vBulletinHook::fetch_hook('arcade_admin_game_tools')) ? eval($hook) : false;
}

// ############################################################################
// Browse Mochiads Games
// ############################################################################
if ($_REQUEST['do'] == 'mochi')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'cat' => TYPE_STR,
		'gotopage' => TYPE_UINT,
		'installmochi' => TYPE_ARRAY,
		'installnow' => TYPE_STR,
		'nextpage' => TYPE_STR,
		'page' => TYPE_UINT,
		'perpage' => TYPE_UINT,
		'prevpage' => TYPE_STR,
		'rating' => TYPE_STR
	));

	if (!empty($vbulletin->GPC['installmochi']))
	{
		// Remove all from current page to allow for un-checking games after re-visting a page
		$vbulletin->v3a_mochitemp = array_diff($vbulletin->v3a_mochitemp, array_keys($vbulletin->GPC['installmochi']));
		
		foreach ($vbulletin->GPC['installmochi'] AS $mid => $install)
		{
			if ($mid AND $install)
			{
				$vbulletin->v3a_mochitemp[] = $mid;
			}
		}

    build_datastore('v3a_mochitemp', serialize($vbulletin->v3a_mochitemp), 1);
	}

	// Install Games Now
	if ($vbulletin->GPC['installnow'])
	{
		exec_header_redirect('v3arcade_admin.php?do=startmochiimport');
	}

	print_cp_header($vbphrase['arcade_games']);

	// What page is this?
	if ($vbulletin->GPC['nextpage'])
	{
		$vbulletin->GPC['page'] += 1;
	}
	else if ($vbulletin->GPC['prevpage'])
	{
		$vbulletin->GPC['page'] -= 1;
	}
	else if ($vbulletin->GPC['gotopage'])
	{
		$vbulletin->GPC['page'] = $vbulletin->GPC['gotopage'];
	}

	if (!$vbulletin->GPC['page'])
	{
		$vbulletin->GPC['page'] = 1;
	}

	if (!$vbulletin->GPC['perpage'])
	{
		$vbulletin->GPC['perpage'] = 20;
	}

	if (!$vbulletin->GPC['cat'])
	{
		$vbulletin->GPC['cat'] = 'leaderboard_enabled';
	}

	if (!$vbulletin->GPC['rating'])
	{
		$vbulletin->GPC['rating'] = 'all';
	}

	$nextpage = false;

	$mochicats = array(
		'leaderboard_enabled' => $vbphrase['mcat_leaderboard_enabled'],
		'featured_games' => $vbphrase['mcat_featured_games'],
		'all' => $vbphrase['all_categories'],
		$vbphrase['mcat_genres'] => array(
			'action' => $vbphrase['mcat_action'],
			'adventure' => $vbphrase['mcat_adventure'],
			'board_game' => $vbphrase['mcat_board_game'],
			'casino' => $vbphrase['mcat_casino'],
			'dress-up' => $vbphrase['mcat_dress_up'],
			'driving' => $vbphrase['mcat_driving'],
			'fighting' => $vbphrase['mcat_fighting'],
			'other' => $vbphrase['mcat_other'],
			'customize' => $vbphrase['mcat_pimp_my_customize'],
			'puzzles' => $vbphrase['mcat_puzzles'],
			'shooting' => $vbphrase['mcat_shooting'],
			'sports' => $vbphrase['mcat_sports']
		)
	);

	$mochirate = array(
		'all' => 'All Ratings',
		'everyone' => 'Everyone',
		'teen' => 'Teen',
		'mature' => 'Mature'
	);

	// Get the list of submitted games
	require_once(DIR . '/includes/class_xml.php');
	$xml = new XMLparser(false, 
		'http://www.mochimedia.com/feeds/games/'
		. $vbulletin->options['arcademochi'] . '/'
		. $vbulletin->GPC['cat'] . '/'
		. $vbulletin->GPC['rating'] .
		'?limit=' . ($vbulletin->GPC['perpage'] + 1) .
		($vbulletin->GPC['page'] > 1 ? '&offset=' . (($vbulletin->GPC['page'] - 1) * $vbulletin->GPC['perpage']) : '')
	);

	if (!$mochi = $xml->parse())
	{
		print_stop_message('xml_error_x_at_line_y', $xml->error_string(), $xml->error_line());
	}

	// Search options header form
	print_form_header('v3arcade_admin', 'mochi', false, true, 'cpform', '90%', '', true, 'get');
	print_table_header($vbphrase['browse_mochiads_games']);
	print_description_row('
		<select name="cat">' . construct_select_options($mochicats, $vbulletin->GPC['cat']) . '</select>&nbsp;
		<select name="rating">' . construct_select_options($mochirate, $vbulletin->GPC['rating']) . '</select>&nbsp;
		<input type="text" name="perpage" size="3" value="' . $vbulletin->GPC['perpage'] . '" /> ' . $vbphrase['per_page']
		, false, true, '', 'center'
	);

	print_submit_row($vbphrase['search']);

	// ##### Browse Games
	print_form_header('v3arcade_admin', 'mochi', false, true, 'cpform', '90%', '', true, 'get');
	construct_hidden_code('cat', $vbulletin->GPC['cat']);
	construct_hidden_code('page', $vbulletin->GPC['page']);
	construct_hidden_code('perpage', $vbulletin->GPC['perpage']);
	construct_hidden_code('rating', $vbulletin->GPC['rating']);

	print_table_header(
		'<span style="float: ' . $stylevar['right'] . '">
			<input type="submit" name="installnow" value="' . $vbphrase['install_selected_games'] . ' &raquo;" class="button" />
		</span>
		<span style="float:' . $stylevar['left'] . '"><input id="allgames" name="allbox" onclick="js_check_all(this.form);" type="checkbox" value="1" title="' . $vbphrase['check_all'] . '" /></span>'
		. (!empty($vbulletin->v3a_mochitemp) ? construct_phrase($vbphrase['x_games_to_be_imported'], sizeof($vbulletin->v3a_mochitemp)) : ''),
		3
	);

	foreach ($mochi['entry'] AS $mochikey => $game)
	{
		// one extra game is called so we know if there's a next page
		if ($mochikey == $vbulletin->GPC['perpage'])
		{
			$nextpage = true;
		}
		else
		{
			$gameid = $game['summary']['div']['dl']['dd']['0']['value'];

			$checked = '';
			if (in_array($gameid, $vbulletin->v3a_mochitemp))
			{
				$checked = 'checked="checked" ';
			}

			$leader_enabled = ($game['summary']['div']['dl']['dd']['9']['value'] == 'True');

			print_cells_row(array(
				'<input type="checkbox" name="installmochi[' . $gameid . ']" value="1" tabindex="1" ' . $checked . '/>',
				'<img alt="" src="' . $game['media:thumbnail']['url'] . '" />',
				($leader_enabled ? '<img src="../images/arcade/trophy.gif" class="inlineimg" alt="" title="' . $vbphrase['leaderboard_enabled'] . '" /> ' : '') . '<strong>' . $game['title'] . '</strong>
				<div class="smallfont" style="padding-bottom: 6px;">
					' . $game['media:description'] . '
				</div>
				<div class="smallfont" style="float: ' . $stylevar['right'] . '">
					' . $vbphrase['published'] . ': ' . $game['published'] . ($game['updated'] != $game['published'] ? '<br />' . $vbphrase['updated'] . ': ' . $game['updated'] : '') . '<br />
					' . $vbphrase['by'] . ' <a href="' . $game['author']['uri'] . '" target="_blank">' . $game['author']['name'] . '</a>
				</div>
				<div class="smallfont"><a href="' . $game['link']['0']['href'] . '" target="_blank">[' . $vbphrase['demo'] . ']</a></div>
					
					
				</div>'
			), false, false, -2);
		}
	}

	print_table_footer(3, 
		'<span style="float: ' . $stylevar['right'] . '">
			<input type="submit" name="installnow" value="' . $vbphrase['install_selected_games'] . ' &raquo;" class="button" />
		</span>' . 
		(($vbulletin->GPC['page'] > 1 OR $nextpage) ? '<span style="float:' . $stylevar['left'] . '">' . $vbphrase['go_to_page'] . '<input type="text" class="bginput" size="2" name="gotopage" value="" tabindex="9" /> <input type="submit" class="button" tabindex="9" value="' . $vbphrase['go'] . '" /></span>' : '') .
		($vbulletin->GPC['page'] > 1 ? '<input type="submit" class="button" value="&laquo; ' . $vbphrase['prev'] . '" name="prevpage" /> ' : '') .
		($nextpage ? '<input type="submit" class="button" value="' . $vbphrase['next'] . ' &raquo;" name="nextpage" /> ' : '')

	);
}

// ############################################################################
// Import Mochi Games
// ############################################################################
if ($_REQUEST['do'] == 'startmochiimport')
{
	print_cp_header($vbphrase['arcade_games']);

	if (!sizeof($vbulletin->v3a_mochitemp))
	{
		print_cp_message($vbphrase['no_games_chosen']);
	}

	print_form_header('v3arcade_admin', 'importmochi');
	print_table_header($vbphrase['import_mochiads_games']);
	print_description_row(
		construct_phrase($vbphrase['x_games_to_be_imported'], sizeof($vbulletin->v3a_mochitemp)),
		false,
		2,
		'thead'
	);
	print_input_row($vbphrase['games_per_page'], 'perpage', 5);
	print_submit_row($vbphrase['import'], false);
}

// ############################################################################
// Do Import Mochi
// ############################################################################
if ($_REQUEST['do'] == 'importmochi')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'page' => TYPE_UINT,
		'perpage' => TYPE_UINT
	));

	print_cp_header($vbphrase['arcade_games']);

	if (empty($vbulletin->v3a_mochitemp))
	{
		print_cp_message($vbphrase['all_games_imported'], 'v3arcade_admin.php?do=games', 1, NULL, true);
	}

	if ($vbulletin->GPC['perpage'] < 1)
	{
		$vbulletin->GPC['perpage'] = 5;
	}

	if ($vbulletin->GPC['page'] < 1)
	{
		$vbulletin->GPC['page'] = 1;
	}

	$gamecache = cache_games();

	require_once(DIR . '/includes/class_xml.php');
	require_once(DIR . '/includes/functions_file.php');

	$full_img_path = realpath($vbulletin->options['arcadeimages']) . '/';
	$full_swf_path = realpath($vbulletin->options['gamedir']) . '/';

	$mochigames = array_splice($vbulletin->v3a_mochitemp, 0, $vbulletin->GPC['perpage']);

	print_dots_start_arcade(
		construct_phrase($vbphrase['installing_x'], $vbphrase['games']) . ' '
		. construct_phrase(
			$vbphrase['page_x_of_y'],
			$vbulletin->GPC['page'],
			ceil((($vbulletin->GPC['page'] * $vbulletin->GPC['perpage']) + sizeof($vbulletin->v3a_mochitemp)) / $vbulletin->GPC['perpage'])
		), '|', 'mochigames'
	);

	// sort through the games list
	foreach ($mochigames AS $mkey => $mid)
	{
		if (!$mid)
		{
			continue;	
		}
		
		$xml = new XMLparser(false, 'http://www.mochimedia.com/feeds/games/' . $vbulletin->options['arcademochi'] . '/' . $mid);

		if ($mochidata = $xml->parse())
		{
			$mochi =& $mochidata['entry'];

			$shortname = substr(strrchr($mochi['link']['0']['href'], '/'), 1);

			if ($gamecache[$shortname])
			{
				echo '<div align="center">' . construct_phrase($vbphrase['x_already_installed'], $mochi['title']) . '</div><br />';
				vbflush();
				continue;
			}

			echo '<div align="center">' . construct_phrase($vbphrase['installing_x'], $mochi['title']) . '...</div><br />';
			vbflush();

			// Import .swf file
			file_put_contents(
				$full_swf_path . $shortname . '.swf',
				fetch_body_request($mochi['media:player']['url'])
			);

			// Import thumbnail image
			$thumbname = '';
			if ($mochi['media:thumbnail']['url'])
			{
				$thumbname = $shortname . strrchr($mochi['media:thumbnail']['url'], '.');

				file_put_contents(
					$full_img_path . $thumbname,
					fetch_body_request($mochi['media:thumbnail']['url'])
				);
			}

			$gameperms = 7;
			if ($mochi['summary']['div']['dl']['dd']['9']['value'] != 'True')
			{
				$gameperms += 8; // disable scoring
			}
			
			insert_v3a_game(array(
				'shortname' => $shortname,
				'title' => $mochi['title'],
				'description' => $mochi['media:description'],
				'instructions' => $mochi['summary']['div']['dl']['dd']['3']['value'],
				'keywords' => $mochi['media:keywords'],
				'width' => intval($mochi['media:player']['width']),
				'height' => intval($mochi['media:player']['height']),
				'miniimage' => $thumbname,
				'stdimage' => $thumbname,
				'gamepermissions' => $gameperms,
				'file' => $shortname . '.swf',
				'dateadded' => TIMENOW,
				'system' => 99
			));
		}
	}

	print_dots_stop_arcade('mochigames');

	// Processed games were removed with array_splice(), so we just need to update the record
	build_datastore('v3a_mochitemp', serialize($vbulletin->v3a_mochitemp), 1);

	print_cp_redirect('v3arcade_admin.php?do=importmochi&perpage=' . $vbulletin->GPC['perpage'] . '&page=' . ($vbulletin->GPC['page'] + 1));
}

// ############################################################################
// v3 IMPORT
// ############################################################################
if ($_REQUEST['do'] == 'v3import')
{
	print_cp_header($vbphrase['arcade_games']);

	$vbulletin->input->clean_array_gpc('r', array(
		'filepath' 	=> TYPE_STR,
		'gamesperpage' => TYPE_UINT
	));

	$gamecache = cache_games();

	$real_path = realpath($vbulletin->GPC['filepath']);
	$games = array();
	$counter = 0;
	$installlog = '';

	$d = dir($real_path);
	while (($filename = $d->read()) AND ($counter < $vbulletin->GPC['gamesperpage']))
	{
		if (substr($filename, strlen($filename) - 9, 9) != '.game.php')
		{
			continue;
		}

		$shortname = substr($filename, 0, strlen($filename)-9);
		if ($gamecache[$shortname])
		{
			$installlog .= construct_phrase($vbphrase['already_installed_x_removed'], $gamecache[$shortname]) . '<br />';
			@unlink($real_path . '/' . $filename);
			@unlink($real_path . '/' . $shortname . '1.gif');
			@unlink($real_path . '/' . $shortname . '2.gif');
			@unlink($real_path . '/' . $shortname . '.swf');

			continue;
		}

		// Read file.
		$gamefile = file_get_contents($real_path . '/' . $filename);

		// Check type.
		if (strpos($gamefile, '$title=\''))
		{
			// Non Standard 1
			preg_match_all("/title='(.*?)';.*description='(.*?)';.*game_width='(.*?)';.*game_height='(.*?)';/s", $gamefile, $gamearray);
		}
		else if (strpos($gamefile, '(shortname, gameid, title, descr, file, width, height, miniimage, stdimage, gamesettings, highscorerid, highscore)'))
		{
			// Standard 1
			preg_match_all("/games \(shortname, gameid, title, descr, file, width, height, miniimage, stdimage, gamesettings, highscorerid, highscore\) VALUES \('.*?', NULL, '(.*?)', '(.*?)', '.*?', (.*?), (.*?),/", $gamefile, $gamearray);
		}
		else
		{
			// Unknown Type
			@unlink($real_path . '/' . $filename);
			@unlink($real_path . '/' . $shortname . '1.gif');
			@unlink($real_path . '/' . $shortname . '2.gif');
			@unlink($real_path . '/' . $shortname . '.swf');
			continue;
		}

		$thisgame = array(
			'shortname' => $shortname,
			'title' => stripslashes($gamearray[1][0]),
			'description' => stripslashes($gamearray[2][0]),
			'width' => intval($gamearray[3][0]),
			'height' => intval($gamearray[4][0]),
			'stdimage' => $shortname . '1.gif',
			'miniimage' => $shortname . '2.gif',
			'file' => $shortname . '.swf',
			'dateadded' => TIMENOW
		);

		// Add the game if we've made it this far
		$installlog .= insert_v3a_game($thisgame);

		@copy(
			$real_path . '/' . $thisgame['file'],
			$real_path . '/../../' . $vbulletin->options['gamedir'] . '/' . $thisgame['file']
		);
		@copy(
			$real_path . '/' . $thisgame['stdimage'],
			$real_path . '/../../' . $vbulletin->options['arcadeimages'] . '/' . $thisgame['stdimage']
		);
		@copy(
			$real_path . '/' . $thisgame['miniimage'],
			$real_path . '/../../' . $vbulletin->options['arcadeimages'] . '/' . $thisgame['miniimage']
		);

		@unlink($real_path . '/' . $filename);
		@unlink($real_path . '/' . $shortname . '1.gif');
		@unlink($real_path . '/' . $shortname . '2.gif');
		@unlink($real_path . '/' . $shortname . '.swf');

		$counter++;
	}
	$d->close();

	print_form_header('v3arcade_admin', 'v3import');

	if (!$installlog)
	{
		print_table_header($vbphrase['importing_games']);
		print_description_row($vbphrase['no_more_games_to_import']);
		print_table_footer();
	}
	else
	{
		print_table_header($vbphrase['importing_games']);
		// Handle hidden fields
		construct_hidden_code('gamesperpage', $vbulletin->GPC['gamesperpage']);
		construct_hidden_code('filepath', $vbulletin->GPC['filepath']);
		print_description_row($installlog);
		print_submit_row($vbphrase['next'], '');
	}
}

// ############################################################################
// iB IMPORT
// ############################################################################
if ($_REQUEST['do'] == 'ibimport')
{
	print_cp_header($vbphrase['arcade_games']);

	$vbulletin->input->clean_array_gpc('r',	array(
		'filepath' => TYPE_STR,
		'gamesperpage' => TYPE_UINT
	));

	$games = array();
	$counter = 0;
	$installlog = '';

	$gamecache = cache_games();

	// Get the class we're going to use to untar files.
	require_once(DIR . '/includes/v3arcade_class_tar.php');
	$gametar = new tar;

	$real_path = realpath($vbulletin->GPC['filepath']);
	$d = dir($real_path);
	while (($filename = $d->read()) AND ($counter < $vbulletin->GPC['gamesperpage']))
	{
		if (substr($filename, strlen($filename)-4, 4) == '.tar')
		{
			if ($gametar->openTAR($vbulletin->GPC['filepath'] . '/' . $filename))
			{
				foreach ($gametar->files as $key => $val)
				{

					// Check to see if a 'gamedata' folder exists for the game and
					// copy it if it does exist.  Needed to run IBP v32+ games.
					// The file {game name}.txt is needed to calculate the game scores.
					if (($startpathpos = strpos($val['name'], 'gamedata/')) !== false)
					{
						$newpath = $real_path . '/../../arcade/gamedata';
						$startpathpos += 9;
						while (($endpathpos = strpos($val['name'], '/', $startpathpos)) != 0)
						{
							$newpath .= '/' . substr( $val['name'], $startpathpos, $endpathpos - $startpathpos );
							// Fix for UMASK problem (Ref: http://us3.php.net/manual/en/function.mkdir.php#33513)
							$old_umask = umask(0);
							// Make the new directory

							if (@mkdir($newpath , 0777))
							{
								// Create a dummy index.htm file
								// Why?  Because paranoia means we can not trust the 'index.htm'
								// file that might be in the tar file.
								if ($handle = fopen($newpath . '/index.htm', 'wb'))
								{
									$html = '<html><head><meta http-equiv="refresh" content="0;url=' . $vbulletin->options['homeurl']  . '"></head><body></body></html>';
									fwrite($handle, $html);
									fclose($handle);
								}
							}

               // Reset the UMASK settings
							umask($old_umask);
							$startpathpos = $endpathpos + 1;
						}

						// Determine *if* we want to copy this file or not.  For security
						// reasons, a 'blind' copy of all files from the /gamedata folder
						// is not done.
						$file_extension = substr(strrchr($val['name'], '.'), 1);
						if (in_array($file_extension, array('swf', 'txt', 'xml', 'mp3', 'jpeg', 'jpg', 'gif', 'png')))
						{
							$newfile = $newpath . '/' . substr($val['name'], $startpathpos);
							// Copy the file
							if ($handle = fopen($newfile, 'wb') )
							{
								fputs($handle, $val['file'], strlen($val['file']));
								fclose($handle);
							}
						}
					}

					if (!strpos($val['name'], '/'))
					{
						// Figure out where this file is going.
						switch (substr($val['name'], strlen($val['name'])-4, 4))
						{
							case '.gif':
								$newfile = $real_path . '/../../' . $vbulletin->options['arcadeimages'] . '/' . $val['name'];
							break;
								case '.swf':
								$newfile = $real_path . '/../../' . $vbulletin->options['gamedir'] . '/' . $val['name'];
							break;
							case '.php':
								$newfile = $real_path . '/' . $val['name'];
								$val['isphp'] = true;
							break;
						}

						if ($handle = fopen($newfile, 'wb') )
						{
							fputs($handle, $val['file'], strlen($val['file']));
							fclose($handle);
						}

						if ($val['isphp'] == true)
						{
							require_once($real_path . '/' . $val['name']);

							if (is_array($config))
							{
								// Game already exists
								if ($gamecache[$config['gname']])
								{
									@unlink($newfile);

									// Get rid of the tar file for good.
									@unlink($real_path . '/' . $filename);
									$installlog .= construct_phrase($vbphrase['already_installed_x_removed'], $gamecache[$thisgame['shortname']]) . '<br />';
								}
								else
								{
									$config['gtitle'] = stripslashes($config['gtitle']);
									
									// Insert the game
									$installlog .= insert_v3a_game(array(
										'shortname' => $config['gname'],
										'title' => $config['gtitle'],
										'description' => stripslashes($config['gwords']),
										'width' => intval($config['gwidth']),
										'height' => intval($config['gheight']),
										'stdimage' => $config['gname'] . '1.gif',
										'miniimage' => $config['gname'] . '2.gif',
										'file' => $config['gname'] . '.swf',
										'dateadded' => TIMENOW,
										'isreverse' => ($config['highscore_type'] == 'high' ? 0 : 1),
										'system' => 10
									));
								}

								@unlink($newfile);
							}
						}
					}

				}
			}

			$counter++;
		}
		@unlink($real_path . '/' . $filename);
	}
	$d->close();

	print_form_header('v3arcade_admin', 'ibimport');

	if (!$installlog)
	{
		print_table_header($vbphrase['importing_games']);
		print_description_row($vbphrase['no_more_games_to_import']);
		print_table_footer();
	}
	else
	{
		print_table_header($vbphrase['importing_games']);
		// Handle hidden fields
		construct_hidden_code('gamesperpage', $vbulletin->GPC['gamesperpage']);
		construct_hidden_code('filepath', $vbulletin->GPC['filepath']);
		print_description_row($installlog);
		print_submit_row($vbphrase['next'], '');
	}
}

// ############################################################################
// SET CHALLENGE PERMISSIONS - Makes it so all users accept challenges.
// ############################################################################
if ($_REQUEST['do'] == 'allchallenge')
{
	print_cp_header($vbphrase['arcade_games']);

	// Query to wipe the scores
	$db->query_write("UPDATE " . TABLE_PREFIX . "user SET arcadeoptions = arcadeoptions+1 WHERE !(arcadeoptions & 1)");

	print_cp_redirect('v3arcade_admin.php?do=dus');
}

// ############################################################################
// MASS SET SETTINGS - Easy and relatively easy permission/setting editing.
// ############################################################################
if ($_REQUEST['do'] == 'processgames')
{
	print_cp_header($vbphrase['arcade_games']);

	$vbulletin->input->clean_array_gpc('r', array(
		'catid' => TYPE_UINT,
		'finished' => TYPE_UINT,
		'gamearray' => TYPE_ARRAY,
		'gp' => TYPE_ARRAY,
		'lastsearch' => TYPE_NOHTML,
		'orderby' => TYPE_NOHTML,
		'pagenumber' => TYPE_UINT,
		'perpage' => TYPE_UINT,
		'title' => TYPE_NOHTML
	));

	$wherequery = '';
	
	// hook to begin the process of editing game settings
	($hook = vBulletinHook::fetch_hook('arcade_admin_game_settings_start')) ? eval($hook) : false;

	// ##### We have games to process
	if ($vbulletin->GPC['gamearray'])
	{
		require_once(DIR . '/includes/functions_misc.php');

		foreach ($vbulletin->GPC['gamearray'] as $gameid => $gamearray)
		{
			// Get that bitfield value calculated.
			$gamearray['gamepermissions'] = convert_array_to_bits($vbulletin->GPC['gp'][$gameid], $vbulletin->bf_misc_gamepermissions);

			$gamearray['width'] = intval($gamearray['width']);
			$gamearray['height'] = intval($gamearray['height']);
			$gamearray['isreverse'] = intval($gamearray['isreverse']);
			$gamearray['categoryid'] = intval($gamearray['categoryid']);
			$gamearray['minpoststotal'] = intval($gamearray['minpoststotal']);
			$gamearray['minpostsperday'] = intval($gamearray['minpostsperday']);
			$gamearray['minpoststhisday'] = intval($gamearray['minpoststhisday']);
			$gamearray['minreglength'] = intval($gamearray['minreglength']);
			$gamearray['minrep'] = intval($gamearray['minrep']);

			// hook for new game fields to be processed
			($hook = vBulletinHook::fetch_hook('arcade_admin_game_settings_save_bit')) ? eval($hook) : false;

			$db->query_write(fetch_query_sql($gamearray, 'v3arcade_games', 'WHERE gameid = ' . $gameid));
		}
	}

	if ($vbulletin->GPC['finished'] AND $vbulletin->GPC['finished'] <= $vbulletin->GPC['pagenumber'])
	{
		print_cp_redirect('v3arcade_admin.php?do=games');
	}

	// Limit by title
	if ($vbulletin->GPC['title'])
	{
		$wherequery = "title LIKE '%" . $db->escape_string($vbulletin->GPC['title']) . "%'";
	}

	// Limit by category
	if ($vbulletin->GPC['catid'])
	{
		$wherequery .= ($wherequery ? ' AND ' : '') . 'games.categoryid = ' . $vbulletin->GPC['catid'];
	}

	if ($wherequery)
	{
		$wherequery = 'WHERE ' . $wherequery;
	}

	// ##### Start processing the main page & settings
	$gamecount = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "v3arcade_games AS games
		$wherequery
	");

	if (($vbulletin->GPC['pagenumber'] < 1) OR ($vbulletin->GPC['lastsearch'] != $vbulletin->GPC['title']))
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}

	if (!$vbulletin->GPC['perpage'])
	{
		$vbulletin->GPC['perpage'] = $vbulletin->options['gamesperpage'];
	}

	$totalpages = ceil($gamecount['total'] / $vbulletin->GPC['perpage']);
	if ($totalpages < 1)
	{
		$totalpages = 1;
	}

	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage'];

	$showprev = ($vbulletin->GPC['pagenumber'] > 1);
	$shownext = ($vbulletin->GPC['pagenumber'] < $totalpages);

	$pageoptions = array();
	for ($i = 1; $i <= $totalpages; $i++)
	{
		$pageoptions["$i"] = "$vbphrase[page] $i / $totalpages";
	}

	// Cache the categories
	$catoptions = fetch_arcade_cats();

	print_form_header('v3arcade_admin', 'processgames');
	echo '
	<colgroup span="5">
		<col style="white-space:nowrap"></col>
		<col></col>
		<col width="100%" align="center"></col>
		<col style="white-space:nowrap"></col>
		<col></col>
	</colgroup>
	<tr>
		<td class="thead" nowrap>' . $vbphrase['game_search'] . ':<input type="hidden" name="lastsearch" value="' . $vbulletin->GPC['title'] . '" /></td>
		<td class="thead"><input type="text" name="title" class="bginput" tabindex="1" value="' . $vbulletin->GPC['title'] . '" /></td>
		<td class="thead">
			' . $vbphrase['show_games_from'] . ' <select name="catid">' . construct_select_options(fetch_arcade_cats(array(0 => $vbphrase['all_categories'])), $vbulletin->GPC['catid']) . '</select>
		</td>
		<td class="thead" nowrap>' . $vbphrase['games_per_page'] . ':</td>
		<td class="thead"><input type="text" class="bginput" name="perpage" value="' . $vbulletin->GPC['perpage'] . '" tabindex="1" size="5" /></td>
		<td class="thead"><input type="submit" class="button" value=" ' . $vbphrase['go'] . ' " tabindex="1" accesskey="s" /></td>
	</tr>';

	print_table_footer(2, '', '', false);

	print_table_start();
	print_table_header('
		<span style="float: ' . $stylevar['right'] . '">
			<input type="button"' . iif(!$showprev, ' disabled="disabled"') . ' class="button" value="&laquo; ' . $vbphrase['prev'] . '" tabindex="1" onclick="document.cpform.page.selectedIndex -= 1; document.cpform.submit()" />
			<select name="page" tabindex="1" onchange="document.cpform.submit()" class="bginput">' . construct_select_options($pageoptions, $vbulletin->GPC['pagenumber']) . '</select>
			<input type="button"' . iif(!$shownext, ' disabled="disabled"') . ' class="button" value="' . $vbphrase['next'] . ' &raquo;" tabindex="1" onclick="document.cpform.page.selectedIndex += 1; document.cpform.submit()" />
		</span>
		<div align="' . $stylevar['left'] . '">' . $vbphrase['arcade_games'] . '</div>', 6);

	$games = $db->query_read("
		SELECT games.*, user.username
		FROM " . TABLE_PREFIX . "v3arcade_games AS games
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (games.highscorerid = user.userid)
		$wherequery
		ORDER BY games.title ASC
		LIMIT $startat, " . $vbulletin->GPC['perpage']
	);
	while ($game = $db->fetch_array($games))
	{
		$game['permissions'] = convert_bits_to_array($game['gamepermissions'], $vbulletin->bf_misc_gamepermissions);

		echo '<tr><td class="thead" colspan="2"><img src="../' . $vbulletin->options['arcadeimages'] . '/' . $game['miniimage'] . '" align="absmiddle" width="' . $vbulletin->options['arcademinithumbsize'] . '" height="' . $vbulletin->options['arcademinithumbsize'] . '" /> ' . $game['title'] . '</td></tr>';

		print_input_row($vbphrase['game_title'], "gamearray[$game[gameid]][title]", $game['title']);
		print_textarea_row($vbphrase['game_description'], "gamearray[$game[gameid]][description]", $game['description']);
		print_select_row($vbphrase['game_category'], "gamearray[$game[gameid]][categoryid]", $catoptions, $game['categoryid']);
		print_textarea_row($vbphrase['game_instructions'], "gamearray[$game[gameid]][instructions]", $game['instructions']);
		print_input_row($vbphrase['game_keywords'], "gamearray[$game[gameid]][keywords]", $game['keywords']);
		print_input_row($vbphrase['width'] . $vbphrase['width_dfn'], "gamearray[$game[gameid]][width]", $game['width']);
		print_input_row($vbphrase['height'] . $vbphrase['height_dfn'], "gamearray[$game[gameid]][height]", $game['height']);

		print_yes_no_row($vbphrase['active'] . $vbphrase['is_active_dfn'], "gp[$game[gameid]][isactive]", $game['permissions']['isactive']);
		print_yes_no_row($vbphrase['disable_high_scores'], "gp[$game[gameid]][disablescoring]", $game['permissions']['disablescoring']);
		print_yes_no_row($vbphrase['show_award'], "gp[$game[gameid]][showaward]", $game['permissions']['showaward']);
		print_yes_no_row($vbphrase['enable_challenges'], "gp[$game[gameid]][enablechallenges]", $game['permissions']['enablechallenges']);
		print_yes_no_row($vbphrase['use_reverse'], "gamearray[$game[gameid]][isreverse]", $game['isreverse']);

		print_input_row($vbphrase['minpoststotal'], "gamearray[$game[gameid]][minpoststotal]", $game['minpoststotal']);
		print_input_row($vbphrase['minpostsperday'], "gamearray[$game[gameid]][minpostsperday]", $game['minpostsperday']);
		print_input_row($vbphrase['minpoststhisday'], "gamearray[$game[gameid]][minpoststhisday]", $game['minpoststhisday']);
		print_input_row($vbphrase['minreglength'], "gamearray[$game[gameid]][minreglength]", $game['minreglength']);
		print_input_row($vbphrase['minrep'], "gamearray[$game[gameid]][minrep]", $game['minrep']);

		// hook for new game fields to be edited
		($hook = vBulletinHook::fetch_hook('arcade_admin_game_settings_edit_bit')) ? eval($hook) : false;
	}

	construct_hidden_code('lastsearch', $vbulletin->GPC['title']);

	if (!$shownext)
	{
		construct_hidden_code('finished', $vbulletin->GPC['pagenumber']);
	}

	print_submit_row($vbphrase['save_and_continue'], '');
	print_table_footer();
}

// ############################################################################
// MASS SET SETTINGS - Easy and relatively easy permission/setting editing.
// ############################################################################
if ($_REQUEST['do'] == 'processcats')
{
	print_cp_header($vbphrase['arcade_games']);

	$vbulletin->input->clean_array_gpc('r', array(
		'title' => TYPE_NOHTML,
		'lastsearch' => TYPE_NOHTML,
		'perpage' => TYPE_UINT,
		'pagenumber' => TYPE_UINT,
		'orderby' => TYPE_NOHTML,
		'finished' => TYPE_UINT,
		'categoryid' => TYPE_ARRAY_UINT
	));

	// If we've been passed categoryid, find out which bitfield arrays we need to clean.
	if (!empty($vbulletin->GPC['categoryid']))
	{
		// And now we save.
		foreach ($vbulletin->GPC['categoryid'] as $id => $val)
		{
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "v3arcade_games SET
					categoryid = $val
				WHERE gameid = $id
			");
		}
	}

	// All done?
	if ($vbulletin->GPC['finished'])
	{
		print_cp_redirect('v3arcade_admin.php?do=gametools');
	}

	$catoptions = array();
	$categories = $db->query_read("
		SELECT categoryid, catname
		FROM " . TABLE_PREFIX . "v3arcade_categories
		WHERE categoryid != 2
		ORDER BY displayorder ASC
	");
	while ($category = $db->fetch_array($categories))
	{
		$catoptions[$category['categoryid']] = $category['catname'];
	}

	$gamecount = $db->query_first("
		SELECT COUNT(*) AS total
		FROM " . TABLE_PREFIX . "v3arcade_games AS arcade_games
		" . iif($vbulletin->GPC['title'], "WHERE title LIKE '%" . $db->escape_string($vbulletin->GPC['title']) . "%'")
	);

	if (($vbulletin->GPC['pagenumber'] < 1) OR ($vbulletin->GPC['lastsearch'] != $vbulletin->GPC['title']))
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}

	if (!$vbulletin->GPC['perpage'])
	{
		$vbulletin->GPC['perpage'] = $vbulletin->options['gamesperpage'];
	}

	$totalpages = ceil($gamecount['total'] / $vbulletin->GPC['perpage']);
	if ($totalpages < 1)
	{
		$totalpages = 1;
	}

	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage'];

	switch($vbulletin->GPC['orderby'])
	{
		// Perhaps some more ordering at a later date.
		case 'title':
		default:
		$order = 'arcade_games.title ASC';
	}

	$showprev = ($vbulletin->GPC['pagenumber'] > 1);
	$shownext = ($vbulletin->GPC['pagenumber'] < $totalpages);

	$pageoptions = array();
	for ($i = 1; $i <= $totalpages; $i++)
	{
		$pageoptions[$i] = "$vbphrase[page] $i / $totalpages";
	}

	print_form_header('v3arcade_admin', 'processcats', false, true, 'navform', '90%', '', true, 'get');
	echo '
	<colgroup span="5">
		<col style="white-space:nowrap"></col>
		<col></col>
		<col width="100%" align="center"></col>
		<col style="white-space:nowrap"></col>
		<col></col>
	</colgroup>
	<tr>
		<td class="thead" nowrap>' . $vbphrase['game_search'] . ':<input type="hidden" name="lastsearch" value="' . $vbulletin->GPC['title'] . '" /></td>
		<td class="thead"><input type="text" name="title" class="bginput" tabindex="1" value="' . $vbulletin->GPC['title'] . '" /></td>
		<td class="thead">
			<input type="button"' . iif(!$showprev, ' disabled="disabled"') . ' class="button" value="&laquo; ' . $vbphrase['prev'] . '" tabindex="1" onclick="this.form.page.selectedIndex -= 1; this.form.submit()" />
			<select name="page" tabindex="1" onchange="this.form.submit()" class="bginput">' . construct_select_options($pageoptions, $vbulletin->GPC['pagenumber']) . '</select>
			<input type="button"' . iif(!$shownext, ' disabled="disabled"') . ' class="button" value="' . $vbphrase['next'] . ' &raquo;" tabindex="1" onclick="this.form.page.selectedIndex += 1; this.form.submit()" />
		</td>
		<td class="thead" nowrap>' . $vbphrase['games_per_page'] . ':</td>
		<td class="thead"><input type="text" class="bginput" name="perpage" value="' . $vbulletin->GPC['perpage'] . '" tabindex="1" size="5" /></td>
		<td class="thead"><input type="submit" class="button" value=" ' . $vbphrase['go'] . ' " tabindex="1" accesskey="s" /></td>
	</tr>';

	print_table_footer();

	print_form_header('v3arcade_admin', 'processcats');
	print_table_header($vbphrase['arcade_games'], 5);

	$games = $db->query_read("
		SELECT arcade_games.*, user.username
		FROM " . TABLE_PREFIX . "v3arcade_games AS arcade_games
		LEFT JOIN " . TABLE_PREFIX . "user AS user ON (arcade_games.highscorerid = user.userid)
		" . iif($vbulletin->GPC['title'], "WHERE arcade_games.title LIKE '%" . $db->escape_string($vbulletin->GPC['title']) . "%'") . "
		ORDER BY $order
		LIMIT $startat, " . $vbulletin->GPC['perpage']
	);
	while ($game = $db->fetch_array($games))
	{
		$game['permissions'] = convert_bits_to_array($game['gamepermissions'], $vbulletin->bf_misc_gamepermissions);

		print_description_row('<img src="../' . $vbulletin->options['arcadeimages'] . '/' . $game['miniimage'] . '" align="absmiddle" width="' . $vbulletin->options['arcademinithumbsize'] . '" height="' . $vbulletin->options['arcademinithumbsize'] . '" /> ' . $game['title'], false, 2, 'thead');
		print_select_row($vbphrase['game_category'], "categoryid[$game[gameid]]", $catoptions, $game['categoryid']);
	}

	construct_hidden_code('pagenumber', $vbulletin->GPC['pagenumber'] + 1);
	construct_hidden_code('perpage', $vbulletin->GPC['perpage']);
	construct_hidden_code('title', $vbulletin->GPC['title']);
	construct_hidden_code('lastsearch', $vbulletin->GPC['title']);
	if (!$shownext)
	{
		construct_hidden_code('finished', 1);
	}

	print_submit_row($vbphrase['save_and_continue'], false);
	print_table_footer();
}

// ############################################################################
// DEFAULT USER SETTINGS
// The default settings.... for users.
// ############################################################################
if ($_REQUEST['do'] == 'dus')
{
	print_cp_header($vbphrase['defaultusersettings']);

	$vbulletin->input->clean_array_gpc('r', array(
		'arcadeoptions' => TYPE_ARRAY_BOOL,
		'process' => TYPE_UINT
	));

	if ($vbulletin->GPC['process'])
	{
		$bittotal = 0;
		foreach ($vbulletin->bf_misc_arcadeoptions AS $key => $val)
		{
			if ($vbulletin->GPC['arcadeoptions'][$key])
			{
				$bittotal += $val;
			}
    }

    build_datastore('arcade_bitdef', $bittotal);
    $db->query_write("
    	ALTER TABLE " . TABLE_PREFIX . "user CHANGE
    		arcadeoptions arcadeoptions INT(10) UNSIGNED NOT NULL DEFAULT '$bittotal'
    ");
	}
	else
	{
		$bittotal = $vbulletin->arcade_bitdef;
	}

	$arcade_array = convert_bits_to_array($bittotal, $vbulletin->bf_misc_arcadeoptions);

	print_form_header('v3arcade_admin', 'dus');
	print_table_header($vbphrase['defaultusersettings']);

	print_description_row($vbphrase['defbitdescr']);
	print_cells_row(array($vbphrase['fields'], ''), true);

	print_checkbox_row($vbphrase['allow_challenges'], 'arcadeoptions[allowchallenges]', $arcade_array['allowchallenges']);
	print_checkbox_row($vbphrase['auto_accept_challenges'], 'arcadeoptions[autoaccept]', $arcade_array['autoaccept']);
	print_checkbox_row($vbphrase['email_notification'], 'arcadeoptions[useemail]', $arcade_array['useemail']);
	print_checkbox_row($vbphrase['pm_notification'], 'arcadeoptions[usepms]', $arcade_array['usepms']);
	print_checkbox_row($vbphrase['high_score_beaten'], 'arcadeoptions[highscorebeaten]', $arcade_array['highscorebeaten']);
	print_checkbox_row($vbphrase['new_challenge_received'], 'arcadeoptions[newchallenge]', $arcade_array['newchallenge']);
	print_checkbox_row($vbphrase['challenge_accepted'], 'arcadeoptions[challengeaccepted]', $arcade_array['challengeaccepted']);
	print_checkbox_row($vbphrase['challenge_declined'], 'arcadeoptions[challengedeclined]', $arcade_array['challengedeclined']);
	print_checkbox_row($vbphrase['finished_challenge'], 'arcadeoptions[finishedchallenge]', $arcade_array['finishedchallenge']);
	print_checkbox_row($vbphrase['tournaments_events'], 'arcadeoptions[tournamentsevents]', $arcade_array['tournamentsevents']);

	construct_hidden_code('process', 1);

	print_submit_row($vbphrase['save'], '');
	print_table_footer();

     print_form_header('v3arcade_admin', 'allchallenge');
     print_table_header($vbphrase['set_all_challenge']);
     print_description_row($vbphrase['set_all_challenge_note']);
     print_submit_row($vbphrase['start'], false);
     print_table_footer();
}

// ############################################################################
// CATEGORIES - Categories contain games.
// ############################################################################
if ($_REQUEST['do'] == 'categories')
{
	print_cp_header($vbphrase['arcade_categories']);

	$vbulletin->input->clean_array_gpc('r', array(
		'cat' 	=> TYPE_ARRAY,
		'process' => TYPE_UINT
	));

	// Process submitted categories first so they'll be ordered correctly below
	if ($vbulletin->GPC['process'])
	{
		$categories = $db->query_read("
			SELECT * FROM " . TABLE_PREFIX . "v3arcade_categories
		");

		while ($category = $db->fetch_array($categories))
		{
			$updatecat = false;
			// sort through the GPC keys to see what's changed
               if (!$vbulletin->GPC['cat'][$category['categoryid']]['isactive'])
               {
                    $vbulletin->GPC['cat'][$category['categoryid']]['isactive'] = 0;
               }
			foreach ($vbulletin->GPC['cat'][$category['categoryid']] AS $newkey => $newval)
			{
				if ($newval != $category[$newkey])
				{
					$updatecat = true;
				}
			}
			if ($updatecat)
			{
				$db->query_write(fetch_query_sql(
					$vbulletin->GPC['cat'][$category['categoryid']],
					'v3arcade_categories',
					'WHERE categoryid = ' . $category['categoryid']
				));
			}
		}

		build_cat_cache();
	}

	?>

<script type="text/javascript">
<!--
function deletecategory(catid)
{
	confirmdelete = confirm('<?php echo $vbphrase['are_you_sure_delete_category']; ?>');
	if (confirmdelete != true)
	{
		return;
	}
	window.location = "v3arcade_admin.php?do=deletecategory&categoryid=" + catid;
}
-->
</script>

	<?php

	print_form_header('v3arcade_admin', 'categories');
	print_table_header($vbphrase['game_categories'], 4);
	print_cells_row(
		array(
			$vbphrase['active'],
			$vbphrase['order'],
			'<div align="left">' . $vbphrase['category_title'] . '</div>',
			$vbphrase['options']
		),
		true
	);

	$categories = $db->query_read("
		SELECT * FROM " . TABLE_PREFIX . "v3arcade_categories
		ORDER BY displayorder ASC
	");
	while ($category = $db->fetch_array($categories))
	{
		exec_switch_bg();
		echo '<tr>
		<td class="' . $bgclass . '"><input type="checkbox" name="cat[' . $category['categoryid'] . '][isactive]" value="1"' . iif($category['isactive']==1, ' checked="checked"') . '/></td>
		<td class="' . $bgclass . '"><input type="text" name="cat[' . $category['categoryid'] . '][displayorder]" value="' . $category['displayorder'] . '" class="bginput" size="3" /></td>
		<td class="' . $bgclass . '" align="left" width="100%"><input type="text" name="cat[' . $category['categoryid'] . '][catname]" value="' . $category['catname'] . '" class="bginput" />
		<td class="' . $bgclass . '" align="right"><input type="button" name="delete" value="' . $vbphrase['delete'] . '" class="button" onclick="return deletecategory(' . $category['categoryid'] . ');" ' . ($category['categoryid'] > 2 ? '' : 'disabled="disabled" ') . '/></td>
	</tr>';
	}

	construct_hidden_code('process', 1);
	print_submit_row($vbphrase['save'], $vbphrase['reset'], 4);

	// Add new category
	print_form_header('v3arcade_admin', 'addcategory');
	print_table_header($vbphrase['add_new_category']);
	print_input_row($vbphrase['category_title'] . $vbphrase['category_title_dfn'], 'cat[catname]');
	print_input_row($vbphrase['display_order'] . $vbphrase['display_order_dfn'], 'cat[displayorder]');
	print_yes_no_row($vbphrase['active'], 'cat[isactive]', 1);
	print_submit_row($vbphrase['add_new_category'], false);

	// Mass process categories
	print_form_header('v3arcade_admin', 'processcats');
	print_table_header($vbphrase['mass_process_game_cats']);
	print_description_row($vbphrase['mass_process_game_cats_note']);
	print_input_row($vbphrase['games_per_page'] . $vbphrase['games_per_page_dfn'], 'perpage', 50);
	print_submit_row($vbphrase['start'], false);
}

// ############################################################################
// ADD CATEGORY
// ############################################################################
if ($_REQUEST['do'] == 'addcategory')
{
	$cat = $vbulletin->input->clean_gpc('r', 'cat', TYPE_ARRAY_NOHTML);
	$cat['displayorder'] = intval($cat['displayorder']);

	$db->query_write(fetch_query_sql($cat, 'v3arcade_categories'));

	build_cat_cache();

	print_cp_redirect('v3arcade_admin.php?do=categories');
}

// ############################################################################
// DELETE CATEGORY
// ############################################################################
if ($_REQUEST['do'] == 'deletecategory')
{
	print_cp_header($vbphrase['arcade_categories']);

	$vbulletin->input->clean_gpc('r', 'categoryid', TYPE_UINT);

	if ($vbulletin->GPC['categoryid'] <= 2)
	{
		// You shouldn't be here...
		exit;
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "v3arcade_categories
		WHERE categoryid = " . $vbulletin->GPC['categoryid']
	);
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "v3arcade_games SET
			categoryid = 1
		WHERE categoryid = " . $vbulletin->GPC['categoryid']
	);

	build_cat_cache();

	print_cp_redirect('v3arcade_admin.php?do=categories');
}


// ############################################################################
// SCORES - Games contain scores.
// ############################################################################
if ($_REQUEST['do'] == 'scores')
{
	print_cp_header($vbphrase['arcade_scores']);
	
	print_form_header('v3arcade_admin', 'removezero');
	print_table_header($vbphrase['remove_zero_scores']);
	print_description_row($vbphrase['remove_zero_scores_dfn']);
	print_submit_row($vbphrase['start'], false);
	
	print_form_header('v3arcade_admin', 'removeuserscores');
	print_table_header($vbphrase['remove_user_scores']);
	print_description_row($vbphrase['remove_user_scores_dfn']);
	print_input_row($vbphrase['user_id'], 'userid');
	print_submit_row($vbphrase['start'], false);
	
	print_form_header('v3arcade_admin', 'rebuildgames');
	print_table_header($vbphrase['rebuild_game_scores']);
	print_description_row($vbphrase['rebuild_game_scores_note']);
	print_submit_row($vbphrase['start'], false);

	print_form_header('v3arcade_admin', 'rebuildcache');
	print_table_header($vbphrase['rebuild_awards_high_score_cache']);
	print_description_row($vbphrase['rebuild_awards_high_score_cache_note']);
	print_submit_row($vbphrase['start'], false);

	print_form_header('v3arcade_admin', 'processwipe');
	print_table_header($vbphrase['wipe_all_scores']);
	print_description_row($vbphrase['wipe_all_scores_note']);
	print_submit_row($vbphrase['wipe_all_scores'], false);
	
	// Additional score tools
	($hook = vBulletinHook::fetch_hook('arcade_admin_score_tools')) ? eval($hook) : false;
}

// ############################################################################
// REMOVE ZERO SCORES
// ############################################################################
if ($_REQUEST['do'] == 'removezero')
{
	print_cp_header($vbphrase['arcade_scores']);

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "v3arcade_sessions
		WHERE score = 0
			AND valid = 1
	");

	build_games();

	print_cp_redirect('v3arcade_admin.php?do=scores');
}

// ############################################################################
// REMOVE USER SCORES
// ############################################################################
if ($_REQUEST['do'] == 'removeuserscores')
{
	$vbulletin->input->clean_gpc('r', 'userid', TYPE_UINT);

	if (!verify_id('user', $vbulletin->GPC['userid'], false))
	{
		print_stop_message('v3_invaliduserid', $vbulletin->GPC['userid']);
	}

	print_cp_header($vbphrase['arcade_scores']);

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "v3arcade_sessions
		WHERE userid = " . $vbulletin->GPC['userid']
	);

	// Additional actions upon removing a user's scores
	($hook = vBulletinHook::fetch_hook('arcade_admin_remove_user_scores')) ? eval($hook) : false;

	build_games();
	build_arcade_champ_cache();
	build_arcade_award_cache();
	
	build_arcade_latest();
	build_tournament_cache();
	build_finished_challenge_cache();
	build_arcade_news_cache();

	print_cp_redirect('v3arcade_admin.php?do=scores');
}

// ############################################################################
// Rebuild Caches
// ############################################################################
if ($_POST['do'] == 'rebuildcache')
{
	print_cp_header($vbphrase['arcade_scores']);
	
	build_arcade_champ_cache();
	build_arcade_award_cache();
	
	build_arcade_latest();
	build_tournament_cache();
	build_finished_challenge_cache();
	build_arcade_news_cache();

	print_cp_redirect('v3arcade_admin.php?do=scores');
}

// ############################################################################
// REBUILD HIGH SCORES - This tool rebuilds high scores after game sessions have been removed.
// ############################################################################
if ($_REQUEST['do'] == 'rebuildgames')
{
	print_cp_header($vbphrase['arcade_games']);

	build_games(1);
	build_arcade_champ_cache();
	build_arcade_award_cache();

	print_cp_redirect('v3arcade_admin.php?do=scores');
}

// ############################################################################
// WIPE ALL SCORES - Holy crap, you're wiping all the scores from the database!
// ############################################################################
if ($_REQUEST['do'] == 'processwipe')
{
	print_cp_header($vbphrase['arcade_games']);

	// Query to wipe the scores
	$db->query_write("DELETE FROM " . TABLE_PREFIX . "v3arcade_sessions");

	// Additional actions upon score wipe
	($hook = vBulletinHook::fetch_hook('arcade_admin_wipe_scores')) ? eval($hook) : false;

	build_games();
	build_arcade_champ_cache();
	build_arcade_award_cache();
	
	build_arcade_latest();

	print_cp_redirect('v3arcade_admin.php?do=scores');
}

// hook for additional actions
($hook = vBulletinHook::fetch_hook('arcade_admin_new_tool')) ? eval($hook) : false;


print_cp_footer();

?>
